<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");
// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve the input data from the JSON body
$data = json_decode(file_get_contents('php://input'), true);

$banner_id = $data['Banner_id'] ?? null;
$seo_title = $data['Seo_title'] ?? null;
$seo_description = $data['Seo_description'] ?? null;
$delete_status = $data['Delete_status'] ?? 0; // Default Delete_status as 0

// Validate required fields
if (!$banner_id || !$seo_title || !$seo_description) {
    echo json_encode(["status" => "error", "message" => "Banner ID, SEO Title, and SEO Description are required"]);
    exit;
}

// Sanitize input to prevent SQL injection
$banner_id = mysqli_real_escape_string($conn, $banner_id);
$seo_title = mysqli_real_escape_string($conn, $seo_title);
$seo_description = mysqli_real_escape_string($conn, $seo_description);
$delete_status = intval($delete_status);

// Insert query
$query = "INSERT INTO banner_seo (Banner_id, Seo_title, Seo_description, Delete_status) 
          VALUES ('$banner_id', '$seo_title', '$seo_description', '$delete_status')";

// Execute the query
if (mysqli_query($conn, $query)) {
    echo json_encode(["status" => "success", "message" => "SEO data for banner inserted successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert SEO data for banner"]);
}

?>
